unit USBTread;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Controls,  D2XXUnit;
//Error conditions
const
  ERROR_GEN_READWRITE = -1 ;
  ERROR_BAD_CHKSUM = -4 ;

  STX	=	15 ;
  ETX	=	4 ;
  DLE	=	5 ;

type
  USBThread = class(TThread)
  private
    procedure Clear(var A: array of Byte);
    procedure Mesage();
    function PutPacket():integer;
    function GetPacket():integer;

  public
      PacketDataRX : array [0..250] of byte ;
      PacketDataTX : array [0..250] of byte ;
      RXFlag, TXFlag : bool;
      LenTX : byte;
      AdaptEnable : bool;
      USBON : boolean;
  protected
    procedure Execute; override;
  end;
var
  BuferRX : array [0..254] of byte;
  ErrorFlag : bool;
  PacketStatus : byte;
  InData : array [0..250] of byte ;
  OutData : array [0..250] of byte ;

implementation

uses  MainAVCUSB;

procedure USBThread.Execute;
label Start;
//var
//DeviceIndex : DWord;
//I: integer;
begin
ErrorFlag := false;

Start:
  AdaptEnable := false;
  FT_Device_Count := 0;
   repeat
      sleep(10);
      GetFTDeviceCount;
   until FT_Device_Count >= 1;


   ErrorFlag := false;
   if USBON then
    begin
      if Open_USB_Device_By_Device_Description( 'AVC USB Interface')<> FT_OK then
        begin
          AdaptEnable := false;
          goto Start;
        end;
      AdaptEnable := true;
      Set_USB_Device_TimeOuts(100,100) ;
      Reset_USB_Device;
    end ;



  while true  do
   begin
      if Terminated then
       begin
         Close_USB_Device ;
         exit;
       end;
      if (GetPacket() <> FT_OK) or (not USBON) then
        begin
         ErrorFlag := true;

         Close_USB_Device ;
         goto Start;
        end
        else
        begin
         Synchronize(Mesage);
         if TXFlag then PutPacket();
        end;
//      sleep(50);
   end;
 Close_USB_Device ;
end;

procedure USBThread.Mesage();
begin
  Form1.ThreadMessage;
end;

procedure USBThread.Clear(var A: array of Byte);
var
 s, I: Integer;
begin
  s := High(A);
  for I := 0 to s do A[I] := 0;
end;



//*****************************************************************************)
//    USB
function USBThread.PutPacket():integer;
var CheckSumm : byte;
DataLen, PacketCount , i : word;
begin
  CheckSumm := 0 ;
  Clear( Ft_Out_Buffer ) ;
  DataLen := LenTX ;
  Ft_Out_Buffer [0] := STX ;
  Ft_Out_Buffer [1] := STX ;
  for i := 0 to DataLen - 1 do CheckSumm := (CheckSumm + PacketDataTX[i]);
  CheckSumm := -CheckSumm ;
  i := 2;
  for PacketCount := 0 to DataLen - 1 do
    begin
     if (PacketDataTX[PacketCount] = STX) or (PacketDataTX[PacketCount] = DLE) or
      (PacketDataTX[PacketCount] = ETX) then
      begin
        Ft_Out_Buffer [i] := DLE ;
        i := i+1;
        Ft_Out_Buffer [i] := PacketDataTX[PacketCount] ;
        i := i+1;
      end else
      begin
        Ft_Out_Buffer [i] := PacketDataTX[PacketCount] ;
        i := i+1;
      end;
    end;

     if (CheckSumm = STX) or (CheckSumm = DLE) or (CheckSumm = ETX) then
      begin
        Ft_Out_Buffer [i] := DLE ;
        i := i+1;
        Ft_Out_Buffer [i] := CheckSumm ;
        i := i+1;
      end else
      begin
        Ft_Out_Buffer [i] := CheckSumm ;
        i := i+1;
      end;

  Ft_Out_Buffer [i] := ETX ;
  result := Write_USB_Device_Buffer(i + 1);
  TXFlag := false;
end;

//*****************************************************************************)
//    USB
function USBThread.GetPacket():integer;
 label m1, m2;
var
  Checksum : byte  ;
  DLEFlag : bool;
  CurPos, i : integer ;


begin
  DLEFlag := false;
  CurPos := 0;
  Checksum := 0 ;
  Clear(PacketDataRX);
  Clear(FT_In_Buffer) ;
 i := 0;
m1:
  repeat
    if Get_USB_Device_QueueStatus <> FT_OK then
      begin
      result := ERROR_GEN_READWRITE;
      exit;
      end;
    if (FT_Q_Bytes = 0)and(TXFlag) then PutPacket();
    if FT_Q_Bytes = 0 then sleep(5);
  until  FT_Q_Bytes >= 1;

  Read_USB_Device_Buffer(1);
      if FT_In_Buffer[0] <> STX then
       begin
        i := 0;
        goto m1;
       end
       else
       begin
        i := i + 1;
        if i = 2 then goto m2 else goto m1;
       end;

m2:
  repeat
    if Get_USB_Device_QueueStatus <> FT_OK then
      begin
      result := ERROR_GEN_READWRITE;
      exit;
      end;
    if (FT_Q_Bytes = 0)and(TXFlag) then PutPacket();
    if FT_Q_Bytes = 0 then sleep(5);
  until  FT_Q_Bytes >= 1;

  Read_USB_Device_Buffer(1);

  if (FT_In_Buffer[0] = DLE)and(DLEFlag = false) then
    begin
     DLEFlag := true;
     goto m2;
    end else
    begin
     if (FT_In_Buffer[0] = ETX)and(DLEFlag = false) then
      begin
       for i := 0 to CurPos - 1 do Checksum := Checksum + PacketDataRX[i];
        if  Checksum <> 0 then
          begin
            result := ERROR_BAD_CHKSUM;
            exit ;
          end ;
      end else
      begin
       DLEFlag := false;
       PacketDataRX[CurPos] := FT_In_Buffer[0];
       CurPos := CurPos + 1;
       goto m2;
      end;
    end;
  result := FT_OK;
end;
//************************************************************************

end.
